package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.BERTaggedObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * SigningTime  ::= Time
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class SigningTime implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */
	
	private Time time;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public SigningTime(Time _time) {
		time = _time;
	}

	public SigningTime(SigningTime _orig) {
		time = _orig.time;
	}

	public static SigningTime getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SigningTime) {
			return (SigningTime)_obj;
		}

		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		return new SigningTime(Time.getInstance(_obj));
	}

	public static SigningTime newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SigningTime) {
			return new SigningTime((SigningTime)_obj);
		}

		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		return new SigningTime(Time.getInstance(_obj));
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public Time getTime() {
		return time;
	}

	private void setTime(Time _time) {
		time = _time;
	}



	public DERObject getDERObject() {
		return time.getDERObject();
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
