package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.BERTaggedObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * SignerInfos ::= SET OF SignerInfo
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class SignerInfos implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERConstructedSet infos;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public SignerInfos(Vector _infos) {
		setInfos(_infos);
	}
	
	public SignerInfos(DERConstructedSet _infos) {
		infos = _infos;
	}

	public SignerInfos(SignerInfos _orig) {
		infos = _orig.infos;
	}

	public static SignerInfos getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SignerInfos) {
			return (SignerInfos)_obj;
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new SignerInfos((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid SignerInfos");
	} 

	public static SignerInfos newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SignerInfos) {
			return new SignerInfos((SignerInfos)_obj);
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new SignerInfos((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid SignerInfos");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public Vector getInfos() {
		int    _len = infos.getSize();
		Vector _res = new Vector();
		for(int i = 0; i < _len; i++) {
			_res.addElement(SignerInfo.getInstance(infos.getObjectAt(i)));
		}
		return _res;
	}

	private void setInfos(Vector _infos) {
		int _len   = _infos.size();
		infos = new DERConstructedSet();
		for(int i = 0; i < _len; i++) {
			infos.addObject(SignerInfo.getInstance(_infos.elementAt(i)));
		}
	}
	
	public DERObject getDERObject() {
		return infos;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
