package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * SignerIdentifier ::= CHOICE {
 * 	issuerAndSerialNumber IssuerAndSerialNumber,
 * 	subjectKeyIdentifier [0] SubjectKeyIdentifier 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class SignerIdentifier implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEREncodable id;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public SignerIdentifier(IssuerAndSerialNumber _id) {
		setId(_id);
	}
	
	public SignerIdentifier(SubjectKeyIdentifier _id) {
		setId(_id);
	}
	

	public SignerIdentifier(DEREncodable _id) {
		if(_id instanceof BERTaggedObject) {
			id = SubjectKeyIdentifier.getInstance(((BERTaggedObject)_id).getObject());
		}
		else {
			id = IssuerAndSerialNumber.getInstance(_id);
		}
	}
	
	public SignerIdentifier(SignerIdentifier _orig) {
		id = _orig.id;
	}

	public static SignerIdentifier getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SignerIdentifier) {
			return (SignerIdentifier)_obj;
		}
		
		if(_obj instanceof DEREncodable) {
			return new SignerIdentifier((DEREncodable)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid SignerIdentifier");
	} 

	public static SignerIdentifier newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SignerIdentifier) {
			return new SignerIdentifier((SignerIdentifier)_obj);
		}
		
		if(_obj instanceof DEREncodable) {
			return new SignerIdentifier((DEREncodable)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid SignerIdentifier");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public DEREncodable getId() {
		return id;
	}
	
	private void setId(IssuerAndSerialNumber _id) {
		id = _id;
	}
	
	private void setId(SubjectKeyIdentifier _id) {
		id = _id;
	}
	
	public DERObject getDERObject() {
		if(id instanceof SubjectKeyIdentifier) {
			return new BERTaggedObject(0, id.getDERObject());
		}
		else {
			return id.getDERObject();
		}
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
