package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * SignedAttributes ::= SET SIZE (1..MAX) OF Attribute
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class SignedAttributes implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERConstructedSet attributes;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public SignedAttributes(Vector _attributes) {
		setAttributes(_attributes);
	}

	public SignedAttributes(DERConstructedSet _attributes) {
		attributes = _attributes;
	}

	public SignedAttributes(SignedAttributes _orig) {
		attributes = _orig.attributes;
	}

	public static SignedAttributes getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SignedAttributes) {
			return (SignedAttributes)_obj;
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new SignedAttributes((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof DERTaggedObject) {
			return getInstance(((DERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid SignedAttributes");
	} 

	public static SignedAttributes newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SignedAttributes) {
			return new SignedAttributes((SignedAttributes)_obj);
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new SignedAttributes((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof DERTaggedObject) {
			return getInstance(((DERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid SignedAttributes");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public Vector getAttributes() {
		int    _len = attributes.getSize();
		Vector _res = new Vector();
		for(int i = 0; i < _len; i++) {
			_res.addElement(Attribute.getInstance(attributes.getObjectAt(i)));
		}
		return _res;
	}

	private void setAttributes(Vector _attributes) {
		int _len   = _attributes.size();
		attributes = new DERConstructedSet();
		for(int i = 0; i < _len; i++) {
			attributes.addObject(Attribute.getInstance(_attributes.elementAt(i)));
		}
	}
	
	public DERObject getDERObject() {
		return attributes;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
