package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * SignatureValue ::= OCTET STRING
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class SignatureValue implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEROctetString value;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public SignatureValue(byte[] _value) {
		setValue(_value);
	}
	
	public SignatureValue(DEROctetString _value) {
		value = _value;
	}

	public SignatureValue(SignatureValue _orig) {
		value = _orig.value;
	}

	public static SignatureValue getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SignatureValue) {
			return (SignatureValue)_obj;
		}
		
		if(_obj instanceof DEROctetString) {
			return new SignatureValue((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid SignatureValue");
	} 

	public static SignatureValue newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SignatureValue) {
			return new SignatureValue((SignatureValue)_obj);
		}
		
		if(_obj instanceof DEROctetString) {
			return new SignatureValue((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid SignatureValue");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public byte[] getValue() {
		return value.getOctets();
	}

	private void setValue(byte[] _value) {
		value = new DEROctetString(_value);
	}



	public DERObject getDERObject() {
		return value;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
