package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * SignatureAlgorithmIdentifier ::= AlgorithmIdentifier
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class SignatureAlgorithmIdentifier implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private AlgorithmIdentifier alg;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public SignatureAlgorithmIdentifier(AlgorithmIdentifier _alg) {
		setAlgorithmIdentifier(_alg);
	}

	public SignatureAlgorithmIdentifier(BERConstructedSequence _obj) {
		alg = new AlgorithmIdentifier(_obj);
	}

	public SignatureAlgorithmIdentifier(SignatureAlgorithmIdentifier _orig) {
		alg = _orig.alg;
	}

	public SignatureAlgorithmIdentifier(DERObjectIdentifier _objectId) {
		alg = new AlgorithmIdentifier(_objectId);
	}

	public SignatureAlgorithmIdentifier(DERObjectIdentifier _objectId, DERObject _parameters) {
		alg = new AlgorithmIdentifier(_objectId, _parameters);
	}

	public static SignatureAlgorithmIdentifier getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SignatureAlgorithmIdentifier) {
			return (SignatureAlgorithmIdentifier)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new SignatureAlgorithmIdentifier((BERConstructedSequence)_obj);
		}

		if(_obj instanceof DERObjectIdentifier) {
			return new SignatureAlgorithmIdentifier((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid SignatureAlgorithmIdentifier");
	}
	
	public static SignatureAlgorithmIdentifier newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof SignatureAlgorithmIdentifier) {
			return new SignatureAlgorithmIdentifier((SignatureAlgorithmIdentifier)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new SignatureAlgorithmIdentifier((BERConstructedSequence)_obj);
		}

		if(_obj instanceof DERObjectIdentifier) {
			return new SignatureAlgorithmIdentifier((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid SignatureAlgorithmIdentifier");
	}
	

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public AlgorithmIdentifier getAlgorithmIdentifier() {
		return alg;
	}

	private void setAlgorithmIdentifier(AlgorithmIdentifier _alg) {
		alg = _alg;
	}


	public DERObject getDERObject() {
		return alg.getDERObject();
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
