package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * 
 * Signature ::= BIT STRING
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class Signature implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */
	
	private DERBitString bitString;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */
	
	public Signature(byte[] _bitString) {
		setBitString(_bitString);
	}
	
	public Signature(DERBitString _bitString) {
		bitString =_bitString;
	}

	public Signature(Signature _orig) {
		bitString =_orig.bitString;
	}

	public static Signature getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof Signature) {
			return (Signature)_obj;
		}
		
		if(_obj instanceof DERBitString) {
			return new Signature((DERBitString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid Signature");
	}

	public static Signature newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof Signature) {
			return new Signature((Signature)_obj);
		}
		
		if(_obj instanceof DERBitString) {
			return new Signature((DERBitString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid Signature");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public byte[] getBitString() {
		return bitString.getBytes();
	}
	
	private void setBitString(byte[] _bitString) {
		bitString = new DERBitString(_bitString);
	}
	
	public DERObject getDERObject() {
		return bitString;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
