package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * RecipientKeyIdentifier ::= SEQUENCE {
 * 	subjectKeyIdentifier SubjectKeyIdentifier,
 * 	date GeneralizedTime OPTIONAL,
 * 	other OtherKeyAttribute OPTIONAL 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class RecipientKeyIdentifier implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private SubjectKeyIdentifier subjectKeyIdentifier;
	private DERGeneralizedTime   date;
	private OtherKeyAttribute    other;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public RecipientKeyIdentifier(SubjectKeyIdentifier _subjectKeyIdentifier,
	                              String               _date,
	                              OtherKeyAttribute    _other) {
		setSubjectKeyIdentifier(_subjectKeyIdentifier);
		setDate(_date);
		setOtherKeyAttribute(_other);
	}
	
	public RecipientKeyIdentifier(BERConstructedSequence _seq) {
		subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(_seq.getObjectAt(0));
		
		switch(_seq.getSize()) {
			case 1 :
				break;
			case 2 :
				try {
					date = (DERGeneralizedTime)_seq.getObjectAt(1); 
				}
				catch(Exception ex) {
					other = OtherKeyAttribute.getInstance(_seq.getObjectAt(2));
				}
				break;
			case 3 :
				date  = (DERGeneralizedTime)_seq.getObjectAt(1);
				other = OtherKeyAttribute.getInstance(_seq.getObjectAt(2));
				break;
			default:
				throw new IllegalArgumentException("Invalid KEKIdentifier");
		}
	}

	public RecipientKeyIdentifier(RecipientKeyIdentifier _orig) {
		subjectKeyIdentifier = _orig.subjectKeyIdentifier;
		date                 = _orig.date;
		other                = _orig.other;
	}
	
	public static RecipientKeyIdentifier getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RecipientKeyIdentifier) {
			return (RecipientKeyIdentifier)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new RecipientKeyIdentifier((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RecipientKeyIdentifier");
	} 

	public static RecipientKeyIdentifier newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RecipientKeyIdentifier) {
			return new RecipientKeyIdentifier((RecipientKeyIdentifier)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new RecipientKeyIdentifier((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RecipientKeyIdentifier");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public SubjectKeyIdentifier getSubjectKeyIdentifier() {
		return subjectKeyIdentifier;
	}

	private void setSubjectKeyIdentifier(SubjectKeyIdentifier _subjectKeyIdentifier) {
		subjectKeyIdentifier = _subjectKeyIdentifier;
	}


	public String getDate() {
		return date.getTime();
	}

	private void setDate(String _date) {
		date = new DERGeneralizedTime(_date);
	}


	public OtherKeyAttribute getOtherKeyAttribute() {
		return other;
	}

	private void setOtherKeyAttribute(OtherKeyAttribute _other) {
		other = _other;
	}



	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		_seq.addObject(subjectKeyIdentifier);
		
		if(date != null) {
			_seq.addObject(date);
		}

		if(other != null) {
			_seq.addObject(other);
		}
		
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
