package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * RecipientInfos ::= SET OF RecipientInfo
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class RecipientInfos implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERConstructedSet infos;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public RecipientInfos(Vector _infos) {
		setInfos(_infos);
	}
	
	public RecipientInfos(DERConstructedSet _infos) {
		infos = _infos;
	}

	public RecipientInfos(RecipientInfos _orig) {
		infos = _orig.infos;
	}

	public static RecipientInfos getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RecipientInfos) {
			return (RecipientInfos)_obj;
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new RecipientInfos((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RecipientInfos");
	}

	public static RecipientInfos newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RecipientInfos) {
			return new RecipientInfos((RecipientInfos)_obj);
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new RecipientInfos((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RecipientInfos");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public Vector getInfos() {
		int    _len = infos.getSize();
		Vector _res = new Vector();
		for(int i = 0; i < _len; i++) {
			_res.addElement(RecipientInfo.getInstance(infos.getObjectAt(i)));
		}
		return _res;
	}

	private void setInfos(Vector _infos) {
		int _len   = _infos.size();
		infos = new DERConstructedSet();
		for(int i = 0; i < _len; i++) {
			infos.addObject(RecipientInfo.getInstance(_infos.elementAt(i)));
		}
	}
	
	public DERObject getDERObject() {
		return infos;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
