package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * RecipientInfo ::= CHOICE {
 * 	ktri KeyTransRecipientInfo,
 * 	kari [1] KeyAgreeRecipientInfo,
 * 	kekri [2] KEKRecipientInfo 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class RecipientInfo implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEREncodable info;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public RecipientInfo(KeyTransRecipientInfo _info) {
		setInfo(_info);
	}
	
	public RecipientInfo(KeyAgreeRecipientInfo _info) {
		setInfo(_info);
	}
	
	public RecipientInfo(KEKRecipientInfo _info) {
		setInfo(_info);
	}
	
	public RecipientInfo(DEREncodable  _info) {
		if(_info instanceof BERTaggedObject) {
			BERTaggedObject _dto = (BERTaggedObject)_info;
			switch(_dto.getTagNo()) {
				case 1 :
					info = KeyAgreeRecipientInfo.getInstance(_dto);
					break;
				case 2 :
					info = KEKRecipientInfo.getInstance(_dto);
					break;
				default:
					throw new IllegalArgumentException("Invalid RecipientInfo");
			}
		}
		else {
			info = KeyTransRecipientInfo.getInstance(_info);
		}
	}
	
	public RecipientInfo(RecipientInfo _orig) {
		info = _orig.info;
	}

	public static RecipientInfo getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RecipientInfo) {
			return (RecipientInfo)_obj;
		}
		
		if(_obj instanceof DEREncodable) {
			return new RecipientInfo((DEREncodable)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RecipientInfo");
	}  

	public static RecipientInfo newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RecipientInfo) {
			return new RecipientInfo((RecipientInfo)_obj);
		}
		
		if(_obj instanceof DEREncodable) {
			return new RecipientInfo((DEREncodable)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RecipientInfo");
	}  

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public DEREncodable getInfo() {
		return info;
	}
	
	private void setInfo(KeyTransRecipientInfo _info) {
		info = _info;
	}
	
	private void setInfo(KeyAgreeRecipientInfo _info) {
		info = _info;
	}
	
	private void setInfo(KEKRecipientInfo _info) {
		info = _info;
	}
	
	public DERObject getDERObject() {
		if(info instanceof KeyAgreeRecipientInfo) {
			return new BERTaggedObject(1, info.getDERObject());
		}
		else if(info instanceof KEKRecipientInfo) {
			return new BERTaggedObject(2, info.getDERObject());
		}
		else {
			return info.getDERObject();
		}
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
