package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * RecipientIdentifier ::= CHOICE {
 * 	issuerAndSerialNumber IssuerAndSerialNumber,
 * 	subjectKeyIdentifier [0] SubjectKeyIdentifier 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class RecipientIdentifier implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	public DEREncodable id;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */
	
	public RecipientIdentifier(IssuerAndSerialNumber _id) {
		setId(_id);
	}
	
	public RecipientIdentifier(SubjectKeyIdentifier _id) {
		setId(_id);
	}
	
	public RecipientIdentifier(DEREncodable _obj) {
		if(_obj instanceof BERTaggedObject) {
			id = SubjectKeyIdentifier.getInstance(((BERTaggedObject)_obj).getObject());
		}
		else {
			id = IssuerAndSerialNumber.getInstance(_obj);
		}
	}

	public RecipientIdentifier(RecipientIdentifier _orig) {
		id = _orig.id;
	}

	public static RecipientIdentifier getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RecipientIdentifier) {
			return (RecipientIdentifier)_obj;
		}
		
		if(_obj instanceof DEREncodable) {
			return new RecipientIdentifier((DEREncodable)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RecipientIdentifier");
	} 

	public static RecipientIdentifier newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RecipientIdentifier) {
			return new RecipientIdentifier((RecipientIdentifier)_obj);
		}
		
		if(_obj instanceof DEREncodable) {
			return new RecipientIdentifier((DEREncodable)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RecipientIdentifier");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public DEREncodable getId() {
		return id;
	}
	
	private void setId(IssuerAndSerialNumber _id) {
		id = _id;
	}
	
	private void setId(SubjectKeyIdentifier _id) {
		id = _id;
	}
	

	public DERObject getDERObject() {
		if(id instanceof IssuerAndSerialNumber) {
			return id.getDERObject();
		}
		else {
			return new BERTaggedObject(0, id.getDERObject());
		}
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
