package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * RecipientEncryptedKeys ::= SEQUENCE OF RecipientEncryptedKey
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class RecipientEncryptedKeys implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private RecipientEncryptedKey[] keys;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public RecipientEncryptedKeys(RecipientEncryptedKey[] _keys) {
		setKeys(_keys);
	}
	
	public RecipientEncryptedKeys(BERConstructedSequence _seq) {

		int _len = _seq.getSize();
		keys = new RecipientEncryptedKey[_seq.getSize()];
		for(int i = 0; i < _len; i++) {
			keys[i] = RecipientEncryptedKey.getInstance(_seq.getObjectAt(i));
		}
	}
	
	public RecipientEncryptedKeys(RecipientEncryptedKeys _orig) {
		keys = _orig.keys;
	}

	public static RecipientEncryptedKeys getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RecipientEncryptedKeys) {
			return (RecipientEncryptedKeys)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new RecipientEncryptedKeys((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RecipientEncryptedKeys");
	} 

	public static RecipientEncryptedKeys newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RecipientEncryptedKeys) {
			return new RecipientEncryptedKeys((RecipientEncryptedKeys)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new RecipientEncryptedKeys((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RecipientEncryptedKeys");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public RecipientEncryptedKey[] getKeys() {
		return keys;
	}
	
	private void setKeys(RecipientEncryptedKey[] _keys) {
		keys = _keys;
	}
	
	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		for(int i = 0; i < keys.length; i++) {
			_seq.addObject(keys[i]);
		}
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
