package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * RecipientEncryptedKey ::= SEQUENCE {
 * 	rid KeyAgreeRecipientIdentifier,
 * 	encryptedKey EncryptedKey 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class RecipientEncryptedKey implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private KeyAgreeRecipientIdentifier rid;
	private EncryptedKey                encryptedKey;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public RecipientEncryptedKey(KeyAgreeRecipientIdentifier _rid,
	                             EncryptedKey                _encryptedKey) {
		
		setRid(_rid);
		setEncryptedKey(_encryptedKey);
	}
	
	public RecipientEncryptedKey(BERConstructedSequence _seq) {
		rid          = KeyAgreeRecipientIdentifier.getInstance(_seq.getObjectAt(0));
		encryptedKey = EncryptedKey.getInstance(_seq.getObjectAt(1));
	}

	public RecipientEncryptedKey(RecipientEncryptedKey _orig) {
		rid          = _orig.rid;
		encryptedKey = _orig.encryptedKey;
	}

	public static RecipientEncryptedKey getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RecipientEncryptedKey) {
			return (RecipientEncryptedKey)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new RecipientEncryptedKey((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RecipientEncryptedKey");
	} 

	public static RecipientEncryptedKey newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RecipientEncryptedKey) {
			return new RecipientEncryptedKey((RecipientEncryptedKey)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new RecipientEncryptedKey((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RecipientEncryptedKey");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public KeyAgreeRecipientIdentifier getRid() {
		return rid;
	}

	private void setRid(KeyAgreeRecipientIdentifier _rid) {
		rid = _rid;
	}


	public EncryptedKey getEncryptedKey() {
		return encryptedKey;
	}

	private void setEncryptedKey(EncryptedKey _encryptedKey) {
		encryptedKey = _encryptedKey;
	}



	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		_seq.addObject(rid);
		_seq.addObject(encryptedKey);
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
