package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * RC2wrapParameter ::= RC2ParameterVersion
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class RC2wrapParameter implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private RC2ParameterVersion param;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public RC2wrapParameter(RC2ParameterVersion _param) {
		param = _param;
	}

	public RC2wrapParameter(RC2wrapParameter _orig) {
		param = _orig.param;
	}

	public static RC2wrapParameter getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RC2wrapParameter) {
			return (RC2wrapParameter)_obj;
		}
		
		return new RC2wrapParameter(RC2ParameterVersion.getInstance(_obj));
	}

	public static RC2wrapParameter newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RC2wrapParameter) {
			return new RC2wrapParameter((RC2wrapParameter)_obj);
		}
		
		return new RC2wrapParameter(RC2ParameterVersion.getInstance(_obj));
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public RC2ParameterVersion getParam() {
		return param;
	}

	private void setParam(RC2ParameterVersion _param) {
		param = _param;
	}



	public DERObject getDERObject() {
		return param.getDERObject();
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
