package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * RC2ParameterVersion ::= INTEGER
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class RC2ParameterVersion implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERInteger version;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public RC2ParameterVersion(BigInteger _version) {
		setVersion(_version);
	}

	public RC2ParameterVersion(DERInteger _version) {
		version = _version;
	}

	public RC2ParameterVersion(RC2ParameterVersion _orig) {
		version = _orig.version;
	}

	public static RC2ParameterVersion getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RC2ParameterVersion) {
			return (RC2ParameterVersion)_obj;
		}
		
		if(_obj instanceof DERInteger) {
			return new RC2ParameterVersion((DERInteger)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RC2ParameterVersion");
	}  

	public static RC2ParameterVersion newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RC2ParameterVersion) {
			return new RC2ParameterVersion((RC2ParameterVersion)_obj);
		}
		
		if(_obj instanceof DERInteger) {
			return new RC2ParameterVersion((DERInteger)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RC2ParameterVersion");
	}  

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public BigInteger getVersion() {
		return version.getValue();
	}

	private void setVersion(BigInteger _version) {
		version = new DERInteger(_version);
	}



	public DERObject getDERObject() {
		return version;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
