package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * RC2CBCParameter ::= SEQUENCE {
 * 	rc2ParameterVersion INTEGER,
 * 	iv OCTET STRING  -- exactly 8 octets
 * }
 * </pre>  
 * 
 * @version 1.0; 
 *     
 */

public class RC2CBCParameter implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERInteger     rc2ParameterVersion;
	private DEROctetString iv;
	

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public RC2CBCParameter(BigInteger _rc2ParameterVersion, byte[] _iv) {
		setRc2ParameterVersion(_rc2ParameterVersion);
		setIv(_iv);
	}
	
	public RC2CBCParameter(BERConstructedSequence _seq) {
		rc2ParameterVersion = (DERInteger)_seq.getObjectAt(0);
		iv                  = (DEROctetString)_seq.getObjectAt(1);
	}

	public RC2CBCParameter(RC2CBCParameter _orig) {
		rc2ParameterVersion = _orig.rc2ParameterVersion;
		iv                  = _orig.iv;
	}

	public static RC2CBCParameter getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RC2CBCParameter) {
			return (RC2CBCParameter)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new RC2CBCParameter((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RC2CBCParameter");
	}  

	public static RC2CBCParameter newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof RC2CBCParameter) {
			return new RC2CBCParameter((RC2CBCParameter)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new RC2CBCParameter((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid RC2CBCParameter");
	}  

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public BigInteger getRc2ParameterVersion() {
		return rc2ParameterVersion.getValue();
	}

	private void setRc2ParameterVersion(BigInteger _rc2ParameterVersion) {
		rc2ParameterVersion = new DERInteger(_rc2ParameterVersion);
	}


	public byte[] getIv() {
		return iv.getOctets();
	}

	private void setIv(byte[] _iv) {
		iv = new DEROctetString(_iv);
	}



	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		_seq.addObject(rc2ParameterVersion);
		_seq.addObject(iv);
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
