package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * OtherKeyAttribute ::= SEQUENCE {
 * 	keyAttrId OBJECT IDENTIFIER,
 * 	keyAttr ANY DEFINED BY keyAttrId OPTIONAL 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class OtherKeyAttribute implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERObjectIdentifier keyAttrId;
	private DERObject           keyAttr;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public OtherKeyAttribute(String _keyAttrId, DERObject _keyAttr) {
		setKeyAttributeId(_keyAttrId);
		setKeyAttribute(_keyAttr);
	}
	
	public OtherKeyAttribute(BERConstructedSequence _seq) {
		keyAttrId = (DERObjectIdentifier)_seq.getObjectAt(0);
		if(_seq.getSize() > 1) {
			keyAttr = (DERObject)_seq.getObjectAt(1);
		}
	}

	public OtherKeyAttribute(OtherKeyAttribute _orig) {
		keyAttrId = _orig.keyAttrId;
		keyAttr   = _orig.keyAttr;
	}
	
	public static OtherKeyAttribute getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof OtherKeyAttribute) {
			return (OtherKeyAttribute)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new OtherKeyAttribute((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid OtherKeyAttribute");
	} 

	public static OtherKeyAttribute newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof OtherKeyAttribute) {
			return new OtherKeyAttribute((OtherKeyAttribute)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new OtherKeyAttribute((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid OtherKeyAttribute");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public String getKeyAttributeId() {
		return keyAttrId.getId();
	}
	
	private void setKeyAttributeId(String _keyAttributeId) {
		keyAttrId = new DERObjectIdentifier(_keyAttributeId);
	}
	
	public DERObject getKeyAttribute() {
		return keyAttr;
	}
	
	private void setKeyAttribute(DERObject _keyAttr) {
		keyAttr = _keyAttr;
	}
	
	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		_seq.addObject(keyAttrId);
		if(keyAttr != null) {
			_seq.addObject(keyAttr);
		}
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
