package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * OriginatorPublicKey ::= SEQUENCE {
 * 	algorithm AlgorithmIdentifier,
 * 	publicKey BIT STRING 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class OriginatorPublicKey implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private AlgorithmIdentifier algorithm;
	private DERBitString        publicKey;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public OriginatorPublicKey(AlgorithmIdentifier _algorithm, byte[] _publicKey) {
		setAlgorithm(_algorithm);
		setPublicKey(_publicKey);
	}
	
	public OriginatorPublicKey(BERConstructedSequence _seq) {
		Object _tmp = _seq.getObjectAt(0);
		if(_tmp instanceof AlgorithmIdentifier) {
			algorithm = (AlgorithmIdentifier)_tmp;
		}
		else if (_tmp instanceof DERObjectIdentifier) {
			algorithm = new AlgorithmIdentifier((DERObjectIdentifier)_tmp);
		}
		else if (_tmp instanceof BERConstructedSequence) {
			algorithm = new AlgorithmIdentifier((BERConstructedSequence)_tmp);
		}
		else {
			throw new IllegalArgumentException("Invalid AlgorithmIdentifier");
		}
		
		publicKey = (DERBitString)_seq.getObjectAt(1);
	}
	
	public OriginatorPublicKey(OriginatorPublicKey _orig) {
		algorithm = _orig.algorithm;
		publicKey = _orig.publicKey;
	}
	
	public static OriginatorPublicKey getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof OriginatorPublicKey) {
			return (OriginatorPublicKey)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new OriginatorPublicKey((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid OriginatorPublicKey");
	} 

	public static OriginatorPublicKey newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof OriginatorPublicKey) {
			return new OriginatorPublicKey((OriginatorPublicKey)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new OriginatorPublicKey((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid OriginatorPublicKey");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public AlgorithmIdentifier getAlgorithm() {
		return algorithm;
	}

	private void setAlgorithm(AlgorithmIdentifier _algorithm) {
		algorithm = _algorithm;
	}

	public byte[] getPublicKey() {
		return publicKey.getBytes();
	}
	
	private void setPublicKey(byte[] _key) {
		publicKey = new DERBitString(_key);
	}

	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		_seq.addObject(algorithm);
		_seq.addObject(publicKey);
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
