package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * OriginatorInfo ::= SEQUENCE {
 * 	certs [0] IMPLICIT CertificateSet OPTIONAL,
 * 	crls [1] IMPLICIT CertificateRevocationLists OPTIONAL 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class OriginatorInfo implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private CertificateSet             certs;
	private CertificateRevocationLists crls;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public OriginatorInfo(CertificateSet _certs, CertificateRevocationLists _crls) {
		setCertificates(_certs);
		setCrls(_crls);
	}
	
	public OriginatorInfo(BERConstructedSequence _seq) {
		switch(_seq.getSize()) {
			case 0 :
				break;
			case 1 :
				BERTaggedObject _dto = (BERTaggedObject)_seq.getObjectAt(0);
				switch(_dto.getTagNo()) {
					case 0 :
						certs = CertificateSet.getInstance(_dto);
						break;
					case 1 :
						crls = CertificateRevocationLists.getInstance(_dto);
						break;
					default:
						throw new IllegalArgumentException("Invalid OriginatorInfo");
				}
				break;
			case 2 :
				certs = CertificateSet.getInstance(_seq.getObjectAt(0));
				crls  = CertificateRevocationLists.getInstance(_seq.getObjectAt(1));
				break;
			default:
				throw new IllegalArgumentException("Invalid OriginatorInfo");
		}
	}
	
	public OriginatorInfo(OriginatorInfo _orig) {
		certs = _orig.certs;
		crls  = _orig.crls;
	}
	
	public static OriginatorInfo getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof OriginatorInfo) {
			return (OriginatorInfo)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new OriginatorInfo((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid OriginatorInfo");
	}
	
	public static OriginatorInfo newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof OriginatorInfo) {
			return new OriginatorInfo((OriginatorInfo)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new OriginatorInfo((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid OriginatorInfo");
	}
	
	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public CertificateSet getCertificates() {
		return certs;
	}

	private void setCertificates(CertificateSet _certs) {
		certs = _certs;
	}


	public CertificateRevocationLists getCrls() {
		return crls;
	}

	private void setCrls(CertificateRevocationLists _crls) {
		crls = _crls;
	}



	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		if(certs != null) {
			_seq.addObject(new BERTaggedObject(false, 0, certs.getDERObject()));
		}
		
		if(crls != null) {
			_seq.addObject(new BERTaggedObject(false, 1, crls.getDERObject()));
		}
		
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
