package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * OriginatorIdentifierOrKey ::= CHOICE {
 * 	issuerAndSerialNumber IssuerAndSerialNumber,
 * 	subjectKeyIdentifier [0] SubjectKeyIdentifier,
 * 	originatorKey [1] OriginatorPublicKey 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class OriginatorIdentifierOrKey implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEREncodable id;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public OriginatorIdentifierOrKey(IssuerAndSerialNumber _id) {
		setId(_id);
	}
	
	public OriginatorIdentifierOrKey(SubjectKeyIdentifier _id) {
		setId(_id);
	}
	
	public OriginatorIdentifierOrKey(OriginatorPublicKey _id) {
		setId(_id);
	}
	
	
	public OriginatorIdentifierOrKey(DEREncodable _obj) {
		if(_obj instanceof BERTaggedObject) {
			BERTaggedObject _dto = (BERTaggedObject)_obj;
			switch(_dto.getTagNo()) {
				case 0 :
					id = SubjectKeyIdentifier.getInstance(_dto.getObject());
					break;
				case 1 :
					id = OriginatorPublicKey.getInstance(_dto.getObject());
					break;
				default:
					throw new IllegalArgumentException("Invalid OriginatorIdentifierOrKey");
			}
		}
		else {
			id = IssuerAndSerialNumber.getInstance(_obj);
		}
	}
	
	public OriginatorIdentifierOrKey(OriginatorIdentifierOrKey _orig) {
		id = _orig.id;
	}
	
	public static OriginatorIdentifierOrKey getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof OriginatorIdentifierOrKey) {
			return (OriginatorIdentifierOrKey)_obj;
		}
		
		if(_obj instanceof DEREncodable) {
			return new OriginatorIdentifierOrKey((DEREncodable)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid OriginatorIdentifierOrKey");
	} 

	public static OriginatorIdentifierOrKey newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof OriginatorIdentifierOrKey) {
			return new OriginatorIdentifierOrKey((OriginatorIdentifierOrKey)_obj);
		}
		
		if(_obj instanceof DEREncodable) {
			return new OriginatorIdentifierOrKey((DEREncodable)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid OriginatorIdentifierOrKey");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public DEREncodable getId() {
		return id;
	}
	
	private void setId(IssuerAndSerialNumber _id) {
		id = _id;
	}
	
	private void setId(SubjectKeyIdentifier _id) {
		id = _id;
	}
	
	private void setId(OriginatorPublicKey _id) {
		id = _id;
	}
	
	public DERObject getDERObject() {
		if(id instanceof SubjectKeyIdentifier) {
			return new BERTaggedObject(0, id.getDERObject());
		}
		else if(id instanceof OriginatorPublicKey) {
			return new BERTaggedObject(1, id.getDERObject());
		}
		
		return id.getDERObject();
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
