package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * MessageDigest ::= OCTET STRING
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class MessageDigest implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEROctetString digest;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public MessageDigest(byte[] _digest) {
		setDigest(_digest);
	}
	
	public MessageDigest(DEROctetString _digest) {
		digest = _digest;
	}

	public MessageDigest(MessageDigest _orig) {
		digest = _orig.digest;
	}

	public static MessageDigest getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof MessageDigest) {
			return (MessageDigest)_obj;
		}
		
		if(_obj instanceof DEROctetString) {
			return new MessageDigest((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid MessageDigest");
	} 

	public static MessageDigest newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof MessageDigest) {
			return new MessageDigest((MessageDigest)_obj);
		}
		
		if(_obj instanceof DEROctetString) {
			return new MessageDigest((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid MessageDigest");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public byte[] getDigest() {
		return digest.getOctets();
	}
	
	private void setDigest(byte[] _digest) {
		digest = new DEROctetString(_digest);
	}
	
	public DERObject getDERObject() {
		return digest;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
