package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;


/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * MessageAuthenticationCodeAlgorithm ::= AlgorithmIdentifier
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class MessageAuthenticationCodeAlgorithm implements DEREncodable{

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private AlgorithmIdentifier alg;


	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public MessageAuthenticationCodeAlgorithm(AlgorithmIdentifier _alg) {
		setAlgorithmIdentifier(_alg);
	}

	public MessageAuthenticationCodeAlgorithm(BERConstructedSequence _obj) {
		alg = new AlgorithmIdentifier(_obj);
	}

	public MessageAuthenticationCodeAlgorithm(MessageAuthenticationCodeAlgorithm _orig) {
		alg = _orig.alg;
	}

	public MessageAuthenticationCodeAlgorithm(DERObjectIdentifier _objectId) {
		alg = new AlgorithmIdentifier(_objectId);
	}

	public MessageAuthenticationCodeAlgorithm(DERObjectIdentifier _objectId, DERObject _parameters) {
		alg = new AlgorithmIdentifier(_objectId, _parameters);
	}
	
	public static MessageAuthenticationCodeAlgorithm getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof MessageAuthenticationCodeAlgorithm) {
			return (MessageAuthenticationCodeAlgorithm)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new MessageAuthenticationCodeAlgorithm((BERConstructedSequence)_obj);
		}

		if(_obj instanceof DERObjectIdentifier) {
			return new MessageAuthenticationCodeAlgorithm((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid MessageAuthenticationCodeAlgorithm");
	}
	
	public static MessageAuthenticationCodeAlgorithm newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof MessageAuthenticationCodeAlgorithm) {
			return new MessageAuthenticationCodeAlgorithm((MessageAuthenticationCodeAlgorithm)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new MessageAuthenticationCodeAlgorithm((BERConstructedSequence)_obj);
		}

		if(_obj instanceof DERObjectIdentifier) {
			return new MessageAuthenticationCodeAlgorithm((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid MessageAuthenticationCodeAlgorithm");
	}
	
	
	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public AlgorithmIdentifier getAlgorithmIdentifier() {
		return alg;
	}

	private void setAlgorithmIdentifier(AlgorithmIdentifier _alg) {
		alg = _alg;
	}


	public DERObject getDERObject() {
		return alg.getDERObject();
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
