package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * MessageAuthenticationCode ::= OCTET STRING
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class MessageAuthenticationCode implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEROctetString mac;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public MessageAuthenticationCode(byte[] _mac) {
		setMac(_mac);
	}
	
	public MessageAuthenticationCode(DEROctetString _mac) {
		mac = _mac;
	}

	public MessageAuthenticationCode(MessageAuthenticationCode _orig) {
		mac = _orig.mac;
	}

	public static MessageAuthenticationCode getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof MessageAuthenticationCode) {
			return (MessageAuthenticationCode)_obj;
		}
		
		if(_obj instanceof DEROctetString) {
			return new MessageAuthenticationCode((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid MessageAuthenticationCode");
	}

	public static MessageAuthenticationCode newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof MessageAuthenticationCode) {
			return new MessageAuthenticationCode((MessageAuthenticationCode)_obj);
		}
		
		if(_obj instanceof DEROctetString) {
			return new MessageAuthenticationCode((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid MessageAuthenticationCode");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public byte[] getMac() {
		return mac.getOctets();
	}
	
	private void setMac(byte[] _mac) {
		mac = new DEROctetString(_mac);
	}
	
	public DERObject getDERObject() {
		return mac;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
