package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;


/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * KeyWrapAlgorithm ::= AlgorithmIdentifier
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class KeyWrapAlgorithm implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private AlgorithmIdentifier alg;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */


	public KeyWrapAlgorithm(AlgorithmIdentifier _alg) {
		setAlgorithmIdentifier(_alg);
	}

	public KeyWrapAlgorithm(BERConstructedSequence _obj) {
		alg = new AlgorithmIdentifier(_obj);
	}

	public KeyWrapAlgorithm(KeyWrapAlgorithm _orig) {
		alg = _orig.alg;
	}

	public KeyWrapAlgorithm(DERObjectIdentifier _objectId) {
		alg = new AlgorithmIdentifier(_objectId);
	}

	public KeyWrapAlgorithm(DERObjectIdentifier _objectId, DERObject _parameters) {
		alg = new AlgorithmIdentifier(_objectId, _parameters);
	}
	
	public static KeyWrapAlgorithm getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof KeyWrapAlgorithm) {
			return (KeyWrapAlgorithm)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new KeyWrapAlgorithm((BERConstructedSequence)_obj);
		}

		if(_obj instanceof DERObjectIdentifier) {
			return new KeyWrapAlgorithm((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid KeyWrapAlgorithm");
	}
	
	public static KeyWrapAlgorithm newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof KeyWrapAlgorithm) {
			return new KeyWrapAlgorithm((KeyWrapAlgorithm)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new KeyWrapAlgorithm((BERConstructedSequence)_obj);
		}

		if(_obj instanceof DERObjectIdentifier) {
			return new KeyWrapAlgorithm((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid KeyWrapAlgorithm");
	}
	

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public AlgorithmIdentifier getAlgorithmIdentifier() {
		return alg;
	}

	private void setAlgorithmIdentifier(AlgorithmIdentifier _alg) {
		alg = _alg;
	}


	public DERObject getDERObject() {
		return alg.getDERObject();
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
