package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;


/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * KeyEncryptionAlgorithmIdentifier ::= AlgorithmIdentifier
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class KeyEncryptionAlgorithmIdentifier implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private AlgorithmIdentifier alg;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public KeyEncryptionAlgorithmIdentifier(AlgorithmIdentifier _alg) {
		setAlgorithmIdentifier(_alg);
	}

	public KeyEncryptionAlgorithmIdentifier(BERConstructedSequence _obj) {
		alg = new AlgorithmIdentifier(_obj);
	}

	public KeyEncryptionAlgorithmIdentifier(KeyEncryptionAlgorithmIdentifier _orig) {
		alg = _orig.alg;
	}

	public KeyEncryptionAlgorithmIdentifier(DERObjectIdentifier _objectId) {
		alg = new AlgorithmIdentifier(_objectId);
	}

	public KeyEncryptionAlgorithmIdentifier(DERObjectIdentifier _objectId, DERObject _parameters) {
		alg = new AlgorithmIdentifier(_objectId, _parameters);
	}

	public static KeyEncryptionAlgorithmIdentifier getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof KeyEncryptionAlgorithmIdentifier) {
			return (KeyEncryptionAlgorithmIdentifier)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new KeyEncryptionAlgorithmIdentifier((BERConstructedSequence)_obj);
		}

		if(_obj instanceof DERObjectIdentifier) {
			return new KeyEncryptionAlgorithmIdentifier((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid KeyEncryptionAlgorithmIdentifier");
	}
	
	public static KeyEncryptionAlgorithmIdentifier newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof KeyEncryptionAlgorithmIdentifier) {
			return new KeyEncryptionAlgorithmIdentifier((KeyEncryptionAlgorithmIdentifier)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new KeyEncryptionAlgorithmIdentifier((BERConstructedSequence)_obj);
		}

		if(_obj instanceof DERObjectIdentifier) {
			return new KeyEncryptionAlgorithmIdentifier((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid KeyEncryptionAlgorithmIdentifier");
	}
	

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public AlgorithmIdentifier getAlgorithmIdentifier() {
		return alg;
	}

	private void setAlgorithmIdentifier(AlgorithmIdentifier _alg) {
		alg = _alg;
	}



	public DERObject getDERObject() {
		return alg.getDERObject();
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
