package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * KeyAgreeRecipientIdentifier ::= CHOICE {
 * 	issuerAndSerialNumber IssuerAndSerialNumber,
 * 	rKeyId [0] IMPLICIT RecipientKeyIdentifier 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class KeyAgreeRecipientIdentifier implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEREncodable id;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */
	
	public KeyAgreeRecipientIdentifier(IssuerAndSerialNumber _issuerAndSerialNumber) {
		setId(_issuerAndSerialNumber);
	}
	
	public KeyAgreeRecipientIdentifier(RecipientKeyIdentifier _rKeyId) {
		setId(_rKeyId);
	}
	
	public KeyAgreeRecipientIdentifier(DEREncodable _obj) {
		if(_obj instanceof BERTaggedObject) {
			id = RecipientKeyIdentifier.getInstance(((BERTaggedObject)_obj).getObject());
		}
		else {
			id = IssuerAndSerialNumber.getInstance(_obj);
		}
	}
	public KeyAgreeRecipientIdentifier(KeyAgreeRecipientIdentifier _orig) {
		id = _orig.id;
	}

	public static KeyAgreeRecipientIdentifier getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof KeyAgreeRecipientIdentifier) {
			return (KeyAgreeRecipientIdentifier)_obj;
		}
		
		if(_obj instanceof DEREncodable) {
			return new KeyAgreeRecipientIdentifier((DEREncodable)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid KeyAgreeRecipientIdentifier");
	} 

	public static KeyAgreeRecipientIdentifier newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof KeyAgreeRecipientIdentifier) {
			return new KeyAgreeRecipientIdentifier((KeyAgreeRecipientIdentifier)_obj);
		}
		
		if(_obj instanceof DEREncodable) {
			return new KeyAgreeRecipientIdentifier((DEREncodable)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid KeyAgreeRecipientIdentifier");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public DEREncodable getId() {
		return id;
	}
	
	private void setId(IssuerAndSerialNumber _issuerAndSerialNumber) {
		id = _issuerAndSerialNumber;
	}
	
	private void setId(RecipientKeyIdentifier _rKeyId) {
		id = _rKeyId;
	}
	
	public DERObject getDERObject() {
		if(id instanceof IssuerAndSerialNumber) {
			return id.getDERObject();
		}
		else {
			return new BERTaggedObject(false, 0, id.getDERObject());
		}
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
