package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * KEKIdentifier ::= SEQUENCE {
 * 	keyIdentifier OCTET STRING,
 * 	date GeneralizedTime OPTIONAL,
 * 	other OtherKeyAttribute OPTIONAL 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class KEKIdentifier implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEROctetString     keyIdentifier;
	private DERGeneralizedTime date;
	private OtherKeyAttribute  other;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */
	
	public KEKIdentifier(byte[] _keyIdentifier, String _date, OtherKeyAttribute _other) {
		setKeyIdentifier(_keyIdentifier);
		setDate(_date);
		setOther(_other);
	}
	
	public KEKIdentifier(BERConstructedSequence _seq) {
		keyIdentifier = (DEROctetString)_seq.getObjectAt(0);
		
		switch(_seq.getSize()) {
			case 1 :
				break;
			case 2 :
				try {
					date = (DERGeneralizedTime)_seq.getObjectAt(1); 
				}
				catch(Exception ex) {
					other = OtherKeyAttribute.getInstance(_seq.getObjectAt(2));
				}
				break;
			case 3 :
				date  = (DERGeneralizedTime)_seq.getObjectAt(1);
				other = OtherKeyAttribute.getInstance(_seq.getObjectAt(2));
				break;
			default:
				throw new IllegalArgumentException("Invalid KEKIdentifier");
		}
	}

	public KEKIdentifier(KEKIdentifier _orig) {
		keyIdentifier = _orig.keyIdentifier;
		date          = _orig.date;
		other         = _orig.other;
	}
	
	public static KEKIdentifier getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof KEKIdentifier) {
			return (KEKIdentifier)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new KEKIdentifier((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid KEKIdentifier");
	}

	public static KEKIdentifier newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof KEKIdentifier) {
			return new KEKIdentifier((KEKIdentifier)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new KEKIdentifier((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid KEKIdentifier");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public byte[] getKeyIdentifier() {
		return keyIdentifier.getOctets();
	}

	private void setKeyIdentifier(byte[] _keyIdentifier) {
		keyIdentifier = new DEROctetString(_keyIdentifier);
	}


	public String getDate() {
		return date.getTime();
	}

	private void setDate(String _date) {
		date = new DERGeneralizedTime(_date);
	}


	public OtherKeyAttribute getOther() {
		return other;
	}

	private void setOther(OtherKeyAttribute _other) {
		other = _other;
	}



	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		_seq.addObject(keyIdentifier);
		
		if(date != null) {
			_seq.addObject(date);
		}

		if(other != null) {
			_seq.addObject(other);
		}
		
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
