package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.X509Name;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * IssuerAndSerialNumber ::= SEQUENCE {
 * 	issuer Name,
 * 	serialNumber CertificateSerialNumber 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class IssuerAndSerialNumber implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private X509Name   issuer;
	private DERInteger serialNumber;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public IssuerAndSerialNumber(X509Name _issuer, BigInteger _serialNumber) {
		setIssuer(_issuer);
		setSerialNumber(_serialNumber);
	}
	
	public IssuerAndSerialNumber(BERConstructedSequence _seq) {
		Object _tmp = _seq.getObjectAt(0);
		if(_tmp instanceof X509Name) {
			issuer = (X509Name)_tmp;
		}
		else if(_tmp instanceof BERConstructedSequence) {
			issuer = new X509Name((BERConstructedSequence)_tmp);
		}
		
		serialNumber = (DERInteger)_seq.getObjectAt(1);
	}

	public IssuerAndSerialNumber(IssuerAndSerialNumber _orig) {
		issuer       = _orig.issuer;
		serialNumber = _orig.serialNumber;
	}

	public static IssuerAndSerialNumber getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof IssuerAndSerialNumber) {
			return (IssuerAndSerialNumber)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new IssuerAndSerialNumber((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid IssuerAndSerialNumber");
	}

	public static IssuerAndSerialNumber newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof IssuerAndSerialNumber) {
			return new IssuerAndSerialNumber((IssuerAndSerialNumber)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new IssuerAndSerialNumber((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid IssuerAndSerialNumber");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public X509Name getIssuer() {
		return issuer;
	}

	private void setIssuer(X509Name _issuer) {
		issuer = _issuer;
	}


	public BigInteger getSerialNumber() {
		return serialNumber.getValue();
	}

	private void setSerialNumber(BigInteger _serialNumber) {
		serialNumber = new DERInteger(_serialNumber);
	}



	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		_seq.addObject(issuer);
		_seq.addObject(serialNumber);
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
