package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * IV ::= OCTET STRING  -- exactly 8 octets
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class IV implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEROctetString iv;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public IV(byte[] _iv) {
		setIV(_iv);
	}
	
	public IV(DEROctetString _iv) {
		iv = _iv;
	}

	public IV(IV _orig) {
		iv = _orig.iv;
	}


	public static IV getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof IV) {
			return (IV)_obj;
		}
		
		if(_obj instanceof DEROctetString) {
			return new IV((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid IV");
	}

	public static IV newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof IV) {
			return new IV((IV)_obj);
		}
		
		if(_obj instanceof DEROctetString) {
			return new IV((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid IV");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public byte[] getIV() {
		return iv.getOctets();
	}
	
	private void setIV(byte[] _iv) {
		iv = new DEROctetString(_iv);
	}
	
	public DERObject getDERObject() {
		return iv;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
