package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

/**	
*	RFC 2630
*	
*	
*	ExtendedCertificateInfo ::= SEQUENCE {
*		version CMSVersion,
*		certificate Certificate,
*		attributes UnauthAttributes 
*	}
*/
public class ExtendedCertificateInfo implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private CMSVersion               version;
	private X509CertificateStructure certificate;
	private UnauthAttributes         attributes;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public ExtendedCertificateInfo(DERConstructedSequence _seq) {
		version = CMSVersion.getInstance(_seq.getObjectAt(0));

		Object _tmp = _seq.getObjectAt(1);
		if(_tmp instanceof X509CertificateStructure) {
			certificate = (X509CertificateStructure)_tmp;
		}
		else if (_tmp instanceof DERConstructedSequence) {
			certificate = new X509CertificateStructure((DERConstructedSequence)_tmp);
		}
		else {
			throw new IllegalArgumentException("Invalid Certificate");
		}
		
		attributes = UnauthAttributes.getInstance(_seq.getObjectAt(2));
	}

	public static ExtendedCertificateInfo getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof ExtendedCertificateInfo) {
			return (ExtendedCertificateInfo)_obj;
		}
		
		if(_obj instanceof DERConstructedSequence) {
			return new ExtendedCertificateInfo((DERConstructedSequence)_obj);
		}
		
		throw new IllegalArgumentException("Invalid ExtendedCertificateInfo");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public DERObject getDERObject() {
		DERConstructedSequence _seq = new DERConstructedSequence();
		_seq.addObject(version);
		_seq.addObject(certificate);
		_seq.addObject(attributes);
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}
