package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/**	
*	RFC 2630
*	
*	
*	ExtendedCertificate ::= SEQUENCE {
*		extendedCertificateInfo ExtendedCertificateInfo,
*		signatureAlgorithm SignatureAlgorithmIdentifier,
*		signature Signature 
*	}
*/
public class ExtendedCertificate implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private ExtendedCertificateInfo      extendedCertificateInfo;
	private SignatureAlgorithmIdentifier signatureAlgorithm;
	private Signature                    signature;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public ExtendedCertificate(DERConstructedSequence _seq) {
		extendedCertificateInfo = ExtendedCertificateInfo.getInstance(_seq.getObjectAt(0));
		signatureAlgorithm      = SignatureAlgorithmIdentifier.getInstance(_seq.getObjectAt(1));
		signature               = Signature.getInstance(_seq.getObjectAt(2));
	}

	public static ExtendedCertificate getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof ExtendedCertificate) {
			return (ExtendedCertificate)_obj;
		}
		
		if(_obj instanceof DERConstructedSequence) {
			return new ExtendedCertificate((DERConstructedSequence)_obj);
		}
		
		throw new IllegalArgumentException("Invalid ExtendedCertificate");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public DERObject getDERObject() {
		DERConstructedSequence _seq = new DERConstructedSequence();
		_seq.addObject(extendedCertificateInfo);
		_seq.addObject(signatureAlgorithm);
		_seq.addObject(signature);
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}
