package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * EncryptedKey ::= OCTET STRING
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class EncryptedKey implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEROctetString key;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public EncryptedKey(byte[] _key) {
		setKey(_key);
	}
	
	public EncryptedKey(DEROctetString _key) {
		key = _key;
	}

	public EncryptedKey(EncryptedKey _orig) {
		key = _orig.key;
	}

	public static EncryptedKey getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof EncryptedKey) {
			return (EncryptedKey)_obj;
		}
		
		if(_obj instanceof DEROctetString) {
			return new EncryptedKey((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid EncryptedKey");
	} 

	public static EncryptedKey newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof EncryptedKey) {
			return new EncryptedKey((EncryptedKey)_obj);
		}
		
		if(_obj instanceof DEROctetString) {
			return new EncryptedKey((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid EncryptedKey");
	} 

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public byte[] getKey() {
		return key.getOctets();
	}
	
	private void setKey(byte[] _key) {
		key = new DEROctetString(_key);
	}
	
	public DERObject getDERObject() {
		return key;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
