package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * EncryptedContent ::= OCTET STRING
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class EncryptedContent implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEROctetString content;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public EncryptedContent(byte[] _content) {
		setContent(_content);
	}
	
	public EncryptedContent(DEROctetString _content) {
		content = _content;
	}

	public EncryptedContent(EncryptedContent _orig) {
		content = _orig.content;
	}

	public static EncryptedContent getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof EncryptedContent) {
			return (EncryptedContent)_obj;
		}
		
		if(_obj instanceof DEROctetString) {
			return new EncryptedContent((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid EncryptedContent");
	}

	public static EncryptedContent newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof EncryptedContent) {
			return new EncryptedContent((EncryptedContent)_obj);
		}
		
		if(_obj instanceof DEROctetString) {
			return new EncryptedContent((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid EncryptedContent");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public byte[] getContent() {
		return content.getOctets();
	}
	
	private void setContent(byte[] _content) {
		content = new DEROctetString(_content);
	}
	
	public DERObject getDERObject() {
		return content;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
