package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * EncapsulatedContentInfo ::= SEQUENCE {
 * 	eContentType ContentType,
 * 	eContent [0] EXPLICIT OCTET STRING OPTIONAL 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class EncapsulatedContentInfo implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private ContentType    eContentType;
	private DEROctetString eContent;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public EncapsulatedContentInfo(ContentType _eContentType, byte[] _eContent) {
		setContentType(_eContentType);
		setContent(_eContent);
	}
	
	public EncapsulatedContentInfo(BERConstructedSequence _seq) {
		eContentType = ContentType.getInstance(_seq.getObjectAt(0));
		if(_seq.getSize() > 1) {
			eContent = (DEROctetString)((BERTaggedObject)_seq.getObjectAt(1)).getObject();
		}
	}

	public EncapsulatedContentInfo(EncapsulatedContentInfo _orig) {
		eContentType = _orig.eContentType;
		eContent     = _orig.eContent;
	}
	
	public static EncapsulatedContentInfo getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof EncapsulatedContentInfo) {
			return (EncapsulatedContentInfo)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new EncapsulatedContentInfo((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid EncapsulatedContentInfo");
	}
	
	public static EncapsulatedContentInfo newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof EncapsulatedContentInfo) {
			return new EncapsulatedContentInfo((EncapsulatedContentInfo)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new EncapsulatedContentInfo((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid EncapsulatedContentInfo");
	}
	
	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public byte[] getContent() {
		return eContent.getOctets();
	}
	
	private void setContent(byte[] _eContent) {
		eContent = new DEROctetString(_eContent);
	}
	
	public ContentType getContentType() {
		return eContentType;
	}
	
	private void setContentType(ContentType _eContentType) {
		eContentType = _eContentType;
	}
	
	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		_seq.addObject(eContentType);
		if(eContent != null) {
			_seq.addObject(new BERTaggedObject(true, 0, eContent.getDERObject()));
		}
		
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
