package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * DigestedData ::= SEQUENCE {
 * 	version CMSVersion,
 * 	digestAlgorithm DigestAlgorithmIdentifier,
 * 	encapContentInfo EncapsulatedContentInfo,
 * 	digest Digest 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class DigestedData implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private CMSVersion                version;
	private DigestAlgorithmIdentifier digestAlgorithm;
	private EncapsulatedContentInfo   encapContentInfo;
	private Digest                    digest;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public DigestedData(CMSVersion                _version,
						DigestAlgorithmIdentifier _digestAlgorithm,
						EncapsulatedContentInfo   _encapContentInfo,
						Digest                    _digest) {
		
		setVersion(_version);
		setDigestAlgorithm(_digestAlgorithm);
		setEncapContentInfo(_encapContentInfo);
		setDigest(_digest);
	}
	
	public DigestedData(BERConstructedSequence _seq) {
		version          = CMSVersion.getInstance(_seq.getObjectAt(0));
		digestAlgorithm  = DigestAlgorithmIdentifier.getInstance(_seq.getObjectAt(1));
		encapContentInfo = EncapsulatedContentInfo.getInstance(_seq.getObjectAt(2));
		digest           = Digest.getInstance(_seq.getObjectAt(2));
	}

	public DigestedData(DigestedData _orig) {
		version          = _orig.version;
		digestAlgorithm  = _orig.digestAlgorithm;
		encapContentInfo = _orig.encapContentInfo;
		digest           = _orig.digest;
	}

	public static DigestedData getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof DigestedData) {
			return (DigestedData)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new DigestedData((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid DigestedData");
	}

	public static DigestedData newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof DigestedData) {
			return new DigestedData((DigestedData)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new DigestedData((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid DigestedData");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public CMSVersion getVersion() {
		return version;
	}

	private void setVersion(CMSVersion _version) {
		version = _version;
	}


	public DigestAlgorithmIdentifier getDigestAlgorithm() {
		return digestAlgorithm;
	}

	private void setDigestAlgorithm(DigestAlgorithmIdentifier _digestAlgorithm) {
		digestAlgorithm = _digestAlgorithm;
	}


	public EncapsulatedContentInfo getEncapContentInfo() {
		return encapContentInfo;
	}

	private void setEncapContentInfo(EncapsulatedContentInfo _encapContentInfo) {
		encapContentInfo = _encapContentInfo;
	}


	public Digest getDigest() {
		return digest;
	}

	private void setDigest(Digest _digest) {
		digest = _digest;
	}



	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		_seq.addObject(version);
		_seq.addObject(digestAlgorithm);
		_seq.addObject(encapContentInfo);
		_seq.addObject(digest);
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
