package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * DigestAlgorithmIdentifiers ::= SET OF DigestAlgorithmIdentifier
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class DigestAlgorithmIdentifiers implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERConstructedSet identifiers;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public DigestAlgorithmIdentifiers(Vector _identifiers) {
		setIdentifiers(_identifiers);
	}
	
	public DigestAlgorithmIdentifiers(DERConstructedSet _identifiers) {
		identifiers = _identifiers;
	}

	public DigestAlgorithmIdentifiers(DigestAlgorithmIdentifiers _orig) {
		identifiers = _orig.identifiers;
	}

	public static DigestAlgorithmIdentifiers getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof DigestAlgorithmIdentifiers) {
			return (DigestAlgorithmIdentifiers)_obj;
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new DigestAlgorithmIdentifiers((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid DigestAlgorithmIdentifiers");
	}

	public static DigestAlgorithmIdentifiers newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof DigestAlgorithmIdentifiers) {
			return new DigestAlgorithmIdentifiers((DigestAlgorithmIdentifiers)_obj);
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new DigestAlgorithmIdentifiers((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid DigestAlgorithmIdentifiers");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public Vector getIdentifiers() {
		int    _len = identifiers.getSize();
		Vector _res = new Vector();
		for(int i = 0; i < _len; i++) {
			_res.addElement(DigestAlgorithmIdentifier.getInstance(identifiers.getObjectAt(i)));
		}
		return _res;
	}

	private void setIdentifiers(Vector _identifiers) {
		int _len   = _identifiers.size();
		identifiers = new DERConstructedSet();
		for(int i = 0; i < _len; i++) {
			identifiers.addObject(DigestAlgorithmIdentifier.getInstance(_identifiers.elementAt(i)));
		}
	}
	
	public DERObject getDERObject() {
		return identifiers;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
