package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;


/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * DigestAlgorithmIdentifier ::= AlgorithmIdentifier
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class DigestAlgorithmIdentifier implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private AlgorithmIdentifier alg;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public DigestAlgorithmIdentifier(AlgorithmIdentifier _alg) {
		setAlgorithmIdentifier(_alg);
	}

	public DigestAlgorithmIdentifier(BERConstructedSequence _obj) {
		alg = new AlgorithmIdentifier(_obj);
	}

	public DigestAlgorithmIdentifier(DigestAlgorithmIdentifier _orig) {
		alg = _orig.alg;
	}

	public DigestAlgorithmIdentifier(DERObjectIdentifier _objectId) {
		alg = new AlgorithmIdentifier(_objectId);
	}

	public DigestAlgorithmIdentifier(DERObjectIdentifier _objectId, DERObject _parameters) {
		alg = new AlgorithmIdentifier(_objectId, _parameters);
	}

	public static DigestAlgorithmIdentifier getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof DigestAlgorithmIdentifier) {
			return (DigestAlgorithmIdentifier)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new DigestAlgorithmIdentifier((BERConstructedSequence)_obj);
		}

		if(_obj instanceof DERObjectIdentifier) {
			return new DigestAlgorithmIdentifier((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid DigestAlgorithmIdentifier");
	}
	
	public static DigestAlgorithmIdentifier newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof DigestAlgorithmIdentifier) {
			return new DigestAlgorithmIdentifier((DigestAlgorithmIdentifier)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new DigestAlgorithmIdentifier((BERConstructedSequence)_obj);
		}

		if(_obj instanceof DERObjectIdentifier) {
			return new DigestAlgorithmIdentifier((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid DigestAlgorithmIdentifier");
	}
	

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public AlgorithmIdentifier getAlgorithmIdentifier() {
		return alg;
	}

	private void setAlgorithmIdentifier(AlgorithmIdentifier _alg) {
		alg = _alg;
	}


	public DERObject getDERObject() {
		return alg.getDERObject();
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
