package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * Digest ::= OCTET STRING
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class Digest implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DEROctetString digest;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public Digest(byte[] _digest) {
		setDigest(_digest);
	}
	
	public Digest(DEROctetString _digest) {
		digest = _digest;
	}

	public Digest(Digest _orig) {
		digest = _orig.digest;
	}

	public static Digest getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof Digest) {
			return (Digest)_obj;
		}
		
		if(_obj instanceof DEROctetString) {
			return new Digest((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid Digest");
	}

	public static Digest newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof Digest) {
			return new Digest((Digest)_obj);
		}
		
		if(_obj instanceof DEROctetString) {
			return new Digest((DEROctetString)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid Digest");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public byte[] getDigest() {
		return digest.getOctets();
	}
	
	private void setDigest(byte[] _digest) {
		digest = new DEROctetString(_digest);
	}
	
	public DERObject getDERObject() {
		return digest;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
