package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * Countersignature ::= SignerInfo
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class CounterSignature implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private SignerInfo signerInfo;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public CounterSignature(SignerInfo _signerInfo) {
		signerInfo = _signerInfo;
	}

	public CounterSignature(CounterSignature _orig) {
		signerInfo = _orig.signerInfo;
	}

	public static CounterSignature getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof CounterSignature) {
			return (CounterSignature)_obj;
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		return new CounterSignature(SignerInfo.getInstance(_obj));
	}

	public static CounterSignature newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof CounterSignature) {
			return new CounterSignature((CounterSignature)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		return new CounterSignature(SignerInfo.getInstance(_obj));
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public SignerInfo getSignerInfo() {
		return signerInfo;
	}

	private void setSignerInfo(SignerInfo _signerInfo) {
		signerInfo = _signerInfo;
	}



	public DERObject getDERObject() {
		return signerInfo.getDERObject();
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
