package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * ContentType ::= OBJECT IDENTIFIER
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class ContentType implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERObjectIdentifier contentType;

	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public ContentType(String _type) {
		setContentType(_type);
	}
	
	public ContentType(DERObjectIdentifier _contentType) {
		contentType = _contentType;
	}

	public ContentType(ContentType _orig) {
		contentType = _orig.contentType;
	}

	public static ContentType getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof ContentType) {
			return (ContentType)_obj;
		}
		
		if(_obj instanceof DERObjectIdentifier) {
			return new ContentType((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid ContentType");
	}
	
	public static ContentType newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof ContentType) {
			return new ContentType((ContentType)_obj);
		}
		
		if(_obj instanceof DERObjectIdentifier) {
			return new ContentType((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid ContentType");
	}
	
	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public String getContentType() {
		return contentType.getId();
	}
	
	private void setContentType(String _type) {
		contentType = new DERObjectIdentifier(_type);
	}
	
	public DERObject getDERObject() {
		return contentType;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
