package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * ContentInfo ::= SEQUENCE {
 * 	contentType ContentType,
 * 	content [0] EXPLICIT ANY DEFINED BY contentType 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class ContentInfo implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */
	
	private ContentType contentType;
	private DERObject   content;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public ContentInfo(ContentType _contentType, DERObject _content) {
		setContentType(_contentType);
		setContent(_content);
	}
	
	public ContentInfo(BERConstructedSequence _seq) {
		contentType = ContentType.getInstance(_seq.getObjectAt(0));
		if(_seq.getSize() > 1) {
			content = (DERObject)(((BERTaggedObject)_seq.getObjectAt(1)).getObject());
		}
	}
	
	public ContentInfo(ContentInfo _orig) {
		contentType = _orig.contentType;
		content     = _orig.content;
	}
	
	public static ContentInfo getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof ContentInfo) {
			return (ContentInfo)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new ContentInfo((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid ContentInfo");
	}

	public static ContentInfo newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof ContentInfo) {
			return new ContentInfo((ContentInfo)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new ContentInfo((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid ContentInfo");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public ContentType getContentType() {
		return contentType;
	}

	private void setContentType(ContentType _contentType) {
		contentType = _contentType;
	}


	public DERObject getContent() {
		return content;
	}

	private void setContent(DERObject _content) {
		content = _content;
	}



	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		_seq.addObject(contentType);
		if(content != null) {
			_seq.addObject(new BERTaggedObject(true, 0, content.getDERObject()));
		}
		
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
