package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;


/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * ContentEncryptionAlgorithmIdentifier ::= AlgorithmIdentifier
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class ContentEncryptionAlgorithmIdentifier implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private AlgorithmIdentifier alg;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */


	public ContentEncryptionAlgorithmIdentifier(AlgorithmIdentifier _alg) {
		setAlgorithmIdentifier(_alg);
	}

	public ContentEncryptionAlgorithmIdentifier(BERConstructedSequence _obj) {
		alg = new AlgorithmIdentifier(_obj);
	}

	public ContentEncryptionAlgorithmIdentifier(ContentEncryptionAlgorithmIdentifier _orig) {
		alg = _orig.alg;
	}

	public ContentEncryptionAlgorithmIdentifier(DERObjectIdentifier _objectId) {
		alg = new AlgorithmIdentifier(_objectId);
	}

	public ContentEncryptionAlgorithmIdentifier(DERObjectIdentifier _objectId, DERObject _parameters) {
		alg = new AlgorithmIdentifier(_objectId, _parameters);
	}

	public static ContentEncryptionAlgorithmIdentifier getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof ContentEncryptionAlgorithmIdentifier) {
			return (ContentEncryptionAlgorithmIdentifier)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new ContentEncryptionAlgorithmIdentifier((BERConstructedSequence)_obj);
		}

		if(_obj instanceof DERObjectIdentifier) {
			return new ContentEncryptionAlgorithmIdentifier((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid ContentEncryptionAlgorithmIdentifier");
	}
	
	public static ContentEncryptionAlgorithmIdentifier newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof ContentEncryptionAlgorithmIdentifier) {
			return new ContentEncryptionAlgorithmIdentifier((ContentEncryptionAlgorithmIdentifier)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new ContentEncryptionAlgorithmIdentifier((BERConstructedSequence)_obj);
		}

		if(_obj instanceof DERObjectIdentifier) {
			return new ContentEncryptionAlgorithmIdentifier((DERObjectIdentifier)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid ContentEncryptionAlgorithmIdentifier");
	}
	

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public AlgorithmIdentifier getAlgorithmIdentifier() {
		return alg;
	}

	private void setAlgorithmIdentifier(AlgorithmIdentifier _alg) {
		alg = _alg;
	}


	public DERObject getDERObject() {
		return alg.getDERObject();
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
