package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * CertificateSet ::= SET OF CertificateChoices
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class CertificateSet implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERConstructedSet certificateChoices;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public CertificateSet(Vector _certificateChoices) {
		setCertificateChoices(_certificateChoices);
	}
	
	public CertificateSet(DERConstructedSet _certificateChoices) {
		certificateChoices = _certificateChoices;
	}

	public CertificateSet(CertificateSet _orig) {
		certificateChoices = _orig.certificateChoices;
	}

	public static CertificateSet getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof CertificateSet) {
			return (CertificateSet)_obj;
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new CertificateSet((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid CertificateSet");
	}

	public static CertificateSet newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof CertificateSet) {
			return new CertificateSet((CertificateSet)_obj);
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new CertificateSet((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid CertificateSet");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public Vector getCertificateChoices() {
		int    _len = certificateChoices.getSize();
		Vector _res = new Vector();
		for(int i = 0; i < _len; i++) {
			_res.addElement(CertificateChoices.getInstance(certificateChoices.getObjectAt(i)));
		}
		return _res;
	}

	private void setCertificateChoices(Vector _certificateChoices) {
		int _len   = _certificateChoices.size();
		certificateChoices = new DERConstructedSet();
		for(int i = 0; i < _len; i++) {
			certificateChoices.addObject(CertificateChoices.getInstance(_certificateChoices.elementAt(i)));
		}
	}
	
	public DERObject getDERObject() {
		return certificateChoices;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
