package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.CertificateList;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * CertificateRevocationLists ::= SET OF CertificateList
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class CertificateRevocationLists implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERConstructedSet crls;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public CertificateRevocationLists(Vector _crls) {
		setCrls(_crls);
	}

	public CertificateRevocationLists(DERConstructedSet _crls) {
		crls = _crls;
	}

	public CertificateRevocationLists(CertificateRevocationLists _orig) {
		crls = _orig.crls;
	}

	public static CertificateRevocationLists getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof CertificateRevocationLists) {
			return (CertificateRevocationLists)_obj;
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new CertificateRevocationLists((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid CertificateRevocationLists");
	}

	public static CertificateRevocationLists newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof CertificateRevocationLists) {
			return new CertificateRevocationLists((CertificateRevocationLists)_obj);
		}
		
		if(_obj instanceof DERConstructedSet) {
			return new CertificateRevocationLists((DERConstructedSet)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid CertificateRevocationLists");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public Vector getCrls() {
		int    _len = crls.getSize();
		Vector _res = new Vector();
		Object _obj;
		for(int i = 0; i < _len; i++) {
			_obj = crls.getObjectAt(i);
			if(_obj instanceof CertificateList) {
				_res.addElement(_obj);
			}
			else {
				_res.addElement(new CertificateList((BERConstructedSequence)_obj));
			}
		}
		return _res;
	}

	private void setCrls(Vector _crls) {
		int _len = _crls.size();
		crls     = new DERConstructedSet();
		Object _obj;
		for(int i = 0; i < _len; i++) {
			_obj = _crls.elementAt(i);
			if(_obj instanceof CertificateList) {
				crls.addObject((CertificateList)_obj);
			}
			else {
				crls.addObject(new CertificateList((BERConstructedSequence)_obj));
			}
		}
	}
	
	public DERObject getDERObject() {
		return crls;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
