package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * CMSVersion ::= INTEGER  { v0(0), v1(1), v2(2), v3(3), v4(4) }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class CMSVersion implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERInteger version;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public CMSVersion(BigInteger _version) {
		setVersion(_version);
	}
	
	public CMSVersion(DERInteger _version) {
		version = _version;
	}

	public CMSVersion(CMSVersion _orig) {
		version = _orig.version;
	}

	public static CMSVersion getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof CMSVersion) {
			return (CMSVersion)_obj;
		}
		
		if(_obj instanceof DERInteger) {
			return new CMSVersion((DERInteger)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid CMSVersion");
	}

	public static CMSVersion newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof CMSVersion) {
			return new CMSVersion((CMSVersion)_obj);
		}
		
		if(_obj instanceof DERInteger) {
			return new CMSVersion((DERInteger)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid CMSVersion");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public BigInteger getVersion() {
		return version.getValue();
	}
	
	private void setVersion(BigInteger _version) {
		version = new DERInteger(_version);
	}
	
	public DERObject getDERObject() {
		return version;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
