package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * CBCParameter ::= IV
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class CBCParameter implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private IV iv;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public CBCParameter(IV _iv) {
		iv = _iv;
	}

	public CBCParameter(CBCParameter _orig) {
		iv = _orig.iv;
	}

	public static CBCParameter getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof CBCParameter) {
			return (CBCParameter)_obj;
		}
		
		return new CBCParameter(IV.getInstance(_obj));
	}

	public static CBCParameter newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof CBCParameter) {
			return new CBCParameter((CBCParameter)_obj);
		}
		
		return new CBCParameter(IV.getInstance(_obj));
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public IV getIv() {
		return iv;
	}

	private void setIv(IV _iv) {
		iv = _iv;
	}



	public DERObject getDERObject() {
		return iv.getDERObject();
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
