package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * AuthenticatedData ::= SEQUENCE {
 * 	version CMSVersion,
 * 	originatorInfo [0] IMPLICIT OriginatorInfo OPTIONAL,
 * 	recipientInfos RecipientInfos,
 * 	macAlgorithm MessageAuthenticationCodeAlgorithm,
 * 	digestAlgorithm [1] DigestAlgorithmIdentifier OPTIONAL,
 * 	encapContentInfo EncapsulatedContentInfo,
 * 	authenticatedAttributes [2] IMPLICIT AuthAttributes OPTIONAL,
 * 	mac MessageAuthenticationCode,
 * 	unauthenticatedAttributes [3] IMPLICIT UnauthAttributes OPTIONAL 
 * }
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class AuthenticatedData implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private CMSVersion                         version;
	private OriginatorInfo                     originatorInfo;
	private RecipientInfos                     recipientInfos;
	private MessageAuthenticationCodeAlgorithm macAlgorithm;
	private DigestAlgorithmIdentifier          digestAlgorithm;
	private EncapsulatedContentInfo            encapContentInfo;
	private AuthAttributes                     authenticatedAttributes;
	private MessageAuthenticationCode          mac;
	private UnauthAttributes                   unauthenticatedAttributes;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */
	
	public AuthenticatedData(CMSVersion                         _version,
	                         OriginatorInfo                     _originatorInfo,
	                         RecipientInfos                     _recipientInfos,
	                         MessageAuthenticationCodeAlgorithm _macAlgorithm,
	                         DigestAlgorithmIdentifier          _digestAlgorithm,
	                         EncapsulatedContentInfo            _encapContentInfo,
	                         AuthAttributes                     _authenticatedAttributes,
	                         MessageAuthenticationCode          _mac,
	                         UnauthAttributes                   _unauthenticatedAttributes) {
		
		
		setVersion(_version);
		setOriginatorInfo(_originatorInfo);
		setRecipientInfos(_recipientInfos);
		setMacAlgorithm(_macAlgorithm);
		setDigestAlgorithm(_digestAlgorithm);
		setEncapContentInfo(_encapContentInfo);
		setAuthenticatedAttributes(_authenticatedAttributes);
		setMac(_mac);
		setUnauthenticatedAttributes(_unauthenticatedAttributes);
	}




	public AuthenticatedData(BERConstructedSequence _seq) {
		int i = 0;
		Object _tmp;
		
		_tmp = _seq.getObjectAt(i++);
		version = CMSVersion.getInstance(_tmp);
		
		_tmp = _seq.getObjectAt(i++);
		if(_tmp instanceof BERTaggedObject) {
			originatorInfo = OriginatorInfo.getInstance(_tmp);
			_tmp = _seq.getObjectAt(i++);
		}
		recipientInfos = RecipientInfos.getInstance(_tmp);

		macAlgorithm = MessageAuthenticationCodeAlgorithm.getInstance(_seq.getObjectAt(i++));
		
		_tmp = _seq.getObjectAt(i++);
		if(_tmp instanceof BERTaggedObject) {
			digestAlgorithm = DigestAlgorithmIdentifier.getInstance(_tmp);
			_tmp = _seq.getObjectAt(i++);
		}
		encapContentInfo = EncapsulatedContentInfo.getInstance(_tmp);
		
		_tmp = _seq.getObjectAt(i++);
		if(_tmp instanceof BERTaggedObject) {
			authenticatedAttributes = AuthAttributes.getInstance(_tmp);
			_tmp = _seq.getObjectAt(i++);
		}
		mac = MessageAuthenticationCode.getInstance(_tmp);
		
		if(_seq.getSize() > i) {
			unauthenticatedAttributes = UnauthAttributes.getInstance(_seq.getObjectAt(i++));
		}
	}

	public AuthenticatedData(AuthenticatedData _orig) {
		version                   = _orig.version;
		originatorInfo            = _orig.originatorInfo;
		recipientInfos            = _orig.recipientInfos;
		macAlgorithm              = _orig.macAlgorithm;
		digestAlgorithm           = _orig.digestAlgorithm;
		encapContentInfo          = _orig.encapContentInfo;
		authenticatedAttributes   = _orig.authenticatedAttributes;
		mac                       = _orig.mac;
		unauthenticatedAttributes = _orig.unauthenticatedAttributes;
	}
	
	public static AuthenticatedData getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof AuthenticatedData) {
			return (AuthenticatedData)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new AuthenticatedData((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid AuthenticatedData");
	}

	public static AuthenticatedData newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof AuthenticatedData) {
			return new AuthenticatedData((AuthenticatedData)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new AuthenticatedData((BERConstructedSequence)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid AuthenticatedData");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */



	public CMSVersion getVersion() {
		return version;
	}

	private void setVersion(CMSVersion _version) {
		version = _version;
	}


	public OriginatorInfo getOriginatorInfo() {
		return originatorInfo;
	}

	private void setOriginatorInfo(OriginatorInfo _originatorInfo) {
		originatorInfo = _originatorInfo;
	}


	public RecipientInfos getRecipientInfos() {
		return recipientInfos;
	}

	private void setRecipientInfos(RecipientInfos _recipientInfos) {
		recipientInfos = _recipientInfos;
	}


	public MessageAuthenticationCodeAlgorithm getMacAlgorithm() {
		return macAlgorithm;
	}

	private void setMacAlgorithm(MessageAuthenticationCodeAlgorithm _macAlgorithm) {
		macAlgorithm = _macAlgorithm;
	}


	public DigestAlgorithmIdentifier getDigestAlgorithm() {
		return digestAlgorithm;
	}

	private void setDigestAlgorithm(DigestAlgorithmIdentifier _digestAlgorithm) {
		digestAlgorithm = _digestAlgorithm;
	}


	public EncapsulatedContentInfo getEncapContentInfo() {
		return encapContentInfo;
	}

	private void setEncapContentInfo(EncapsulatedContentInfo _encapContentInfo) {
		encapContentInfo = _encapContentInfo;
	}


	public AuthAttributes getAuthenticatedAttributes() {
		return authenticatedAttributes;
	}

	private void setAuthenticatedAttributes(AuthAttributes _authenticatedAttributes) {
		authenticatedAttributes = _authenticatedAttributes;
	}


	public MessageAuthenticationCode getMac() {
		return mac;
	}

	private void setMac(MessageAuthenticationCode _mac) {
		mac = _mac;
	}


	public UnauthAttributes getUnauthenticatedAttributes() {
		return unauthenticatedAttributes;
	}

	private void setUnauthenticatedAttributes(UnauthAttributes _unauthenticatedAttributes) {
		unauthenticatedAttributes = _unauthenticatedAttributes;
	}

	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		_seq.addObject(version);
		
		if(originatorInfo != null) {
			_seq.addObject(new BERTaggedObject(false, 0, originatorInfo.getDERObject()));
		}

		_seq.addObject(recipientInfos);
		_seq.addObject(macAlgorithm);
		
		if(digestAlgorithm != null) {
			_seq.addObject(new BERTaggedObject(1, digestAlgorithm.getDERObject()));
		}
		
		_seq.addObject(encapContentInfo);
		
		if(authenticatedAttributes != null) {
			_seq.addObject(new BERTaggedObject(false, 2, authenticatedAttributes.getDERObject()));
		}
		
		_seq.addObject(mac);
		
		if(unauthenticatedAttributes != null) {
			_seq.addObject(new BERTaggedObject(false, 3, unauthenticatedAttributes.getDERObject()));
		}
		
		return _seq;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
