package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * AttributeValue ::= ANY
 * </pre>
 * 
 * @version 1.0; 
 *     
 */

public class AttributeValue implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERObject value;
	
	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public AttributeValue(DERObject _value) {
		setValue(_value);
	}
	
	public AttributeValue(AttributeValue _orig) {
		value = _orig.value;
	}
	
	public static AttributeValue getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof AttributeValue) {
			return (AttributeValue)_obj;
		}
		
		if(_obj instanceof DERObject) {
			return new AttributeValue((DERObject)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid AttributeValue");
	}
	
	public static AttributeValue newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof AttributeValue) {
			return new AttributeValue((AttributeValue)_obj);
		}
		
		if(_obj instanceof DERObject) {
			return new AttributeValue((DERObject)_obj);
		}
		
		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid AttributeValue");
	}
	
	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */

	public DERObject getValue() {
		return value;
	}

	private void setValue(DERObject _value) {
		value = _value;
	}


	
	public DERObject getDERObject() {
		return value;
	}

	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
