package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;

/** 
 * <br>
 * <pre>
 * RFC 2630
 * 
 * Attribute ::= SEQUENCE {
 * 	attrType OBJECT IDENTIFIER,
 * 	attrValues SET OF AttributeValue
 * }
 * </pre>
 * @version 1.0; 
 *     
 */

public class Attribute implements DEREncodable {

	/*
	 *
	 *  VARIABLES
	 *
	 */

	private DERObjectIdentifier attrType;
	private DERConstructedSet   attrValues;

	/*
	 *
	 *  CONSTRUCTORS
	 *
	 */

	public Attribute(String _attrType, Vector _attrValues) {
		setAttrType(_attrType);
		setAttrValues(_attrValues);
	}
	
	public Attribute(BERConstructedSequence _seq) {
		attrType   = (DERObjectIdentifier)_seq.getObjectAt(0);
		attrValues = (DERConstructedSet)_seq.getObjectAt(1);
	}
	
	public Attribute(Attribute _orig) {
		attrType   = _orig.attrType;
		attrValues = _orig.attrValues;
	}
	
	public static Attribute getInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof Attribute) {
			return (Attribute)_obj;
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new Attribute((BERConstructedSequence)_obj);
		}

		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid Attribute");
	}

	public static Attribute newInstance(Object _obj) {
		if(_obj == null) {
			return null;
		}
		
		if(_obj instanceof Attribute) {
			return new Attribute((Attribute)_obj);
		}
		
		if(_obj instanceof BERConstructedSequence) {
			return new Attribute((BERConstructedSequence)_obj);
		}

		if(_obj instanceof BERTaggedObject) {
			return getInstance(((BERTaggedObject)_obj).getObject());
		}
		
		throw new IllegalArgumentException("Invalid Attribute");
	}

	/*
	 *
	 *  BUSINESS METHODS
	 *
	 */


	public String getAttrType() {
		return attrType.getId();
	}

	private void setAttrType(String _attrType) {
		attrType = new DERObjectIdentifier(_attrType);
	}


	public Vector getAttrValues() {
		int    _len = attrValues.getSize();
		Vector _res = new Vector();
		for(int i = 0; i < _len; i++) {
			_res.addElement(AttributeValue.getInstance(attrValues.getObjectAt(i)));
		}
		return _res;
	}

	private void setAttrValues(Vector _attrValues) {
		int _len   = _attrValues.size();
		attrValues = new DERConstructedSet();
		for(int i = 0; i < _len; i++) {
			attrValues.addObject(AttributeValue.getInstance(_attrValues.elementAt(i)));
		}
	}

	public DERObject getDERObject() {
		BERConstructedSequence _seq = new BERConstructedSequence();
		_seq.addObject(attrType);
		_seq.addObject(attrValues);
		return _seq;
	}


	/*
	 *
	 *  INTERNAL METHODS
	 *
	 */


}


/**
 * Version History
 * ~~~~~~~~~~~~~~~
 * 1.0
 *     - Created [CK]
 * 
 */
