package org.bouncycastle.asn1;

import java.io.*;
import java.util.*;

public class DERConstructedSet
    extends DERObject
{
    private Vector set = new Vector();

    public DERConstructedSet()
    {
    }

    public void addObject(
        DEREncodable obj)
    {
        set.addElement(obj);
    }

    public Enumeration getObjects()
    {
        return set.elements();
    }

    /**
     * return the object at the set postion indicated by index.
     *
     * @param the set number (starting at zero) of the object
     * @return the object at the set postion indicated by index.
     */
    public DEREncodable getObjectAt(
        int index)
    {
        return (DEREncodable)set.elementAt(index);
    }

    /**
     * return the number of objects in this set.
     *
     * @return the number of objects in this set.
     */
    public int getSize()
    {
        return set.size();
    }

    /*
     * A note on the implementation:
     * <p>
     * As DER requires the constructed, definite-length model to
     * be used for structured types, this varies slightly from the
     * ASN.1 descriptions given. Rather than just outputing SET,
     * we also have to specify CONSTRUCTED, and the objects length.
     */
    void encode(
        DEROutputStream out)
        throws IOException
    {
        ByteArrayOutputStream   bOut = new ByteArrayOutputStream();
        DEROutputStream         dOut = new DEROutputStream(bOut);
        Enumeration             e = getObjects();

        while (e.hasMoreElements())
        {
            Object    obj = e.nextElement();

            dOut.writeObject(obj);
        }

        dOut.close();

        byte[]  bytes = bOut.toByteArray();

        out.writeEncoded(SET | CONSTRUCTED, bytes);
    }
}
